/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaFocusRingManager;
import org.violetlib.aqua.AquaFullKeyboardFocusableHandler;
import org.violetlib.aqua.AquaPainting;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.FocusRingOutlineProvider;
import org.violetlib.geom.ExpandableOutline;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.SliderPainter;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.aqua.SliderLayoutConfiguration;

public class AquaSliderUI
extends BasicSliderUI
implements AquaUtilControlSize.Sizeable,
FocusRingOutlineProvider {
    final AquaUIPainter painter = AquaPainting.create();
    protected AquaUIPainter.Size sizeVariant = AquaUIPainter.Size.REGULAR;
    protected int fixedWidth;
    protected int fixedHeight;
    protected int leftTrackBuffer;
    protected int rightTrackBuffer;
    protected Color tickColor;
    private boolean oldRequestFocusEnabled;
    protected transient boolean fIsDragging = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaSliderUI((JSlider)jComponent);
    }

    public AquaSliderUI(JSlider jSlider) {
        super(jSlider);
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        LookAndFeel.installProperty(this.slider, "opaque", Boolean.FALSE);
        this.tickColor = UIManager.getColor("Slider.tickColor");
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider jSlider) {
        return new TrackListener();
    }

    @Override
    protected void installDefaults(JSlider jSlider) {
        super.installDefaults(jSlider);
        this.oldRequestFocusEnabled = jSlider.isRequestFocusEnabled();
        jSlider.setRequestFocusEnabled(false);
    }

    @Override
    protected void uninstallDefaults(JSlider jSlider) {
        jSlider.setRequestFocusEnabled(this.oldRequestFocusEnabled);
        super.uninstallDefaults(jSlider);
    }

    @Override
    protected void installListeners(JSlider jSlider) {
        super.installListeners(jSlider);
        AquaFocusHandler.install(jSlider);
        AquaUtilControlSize.addSizePropertyListener(jSlider);
        AquaFullKeyboardFocusableHandler.addListener(jSlider);
    }

    @Override
    protected void uninstallListeners(JSlider jSlider) {
        AquaUtilControlSize.removeSizePropertyListener(jSlider);
        AquaFocusHandler.uninstall(jSlider);
        super.uninstallListeners(jSlider);
        AquaFullKeyboardFocusableHandler.removeListener(jSlider);
    }

    @Override
    public void applySizeFor(JComponent jComponent, AquaUIPainter.Size size, boolean bl) {
        this.sizeVariant = size;
        if (this.focusRect != null) {
            if (size == AquaUIPainter.Size.SMALL) {
                size = AquaUIPainter.Size.MINI;
            }
            AquaUtilControlSize.configureFontFromSize(jComponent, size);
        }
    }

    protected void updateFixedDimension() {
        int n;
        int n2 = this.slider.getMaximum() - this.slider.getMinimum();
        int n3 = 0;
        if (this.slider.getPaintTicks() && (n = this.getTickSpacing()) > 0) {
            n3 = n2 / n;
        }
        n = this.slider.getOrientation() == 0 ? 1 : 0;
        AquaUIPainter.TickMarkPosition tickMarkPosition = n != 0 ? AquaUIPainter.TickMarkPosition.BELOW : AquaUIPainter.TickMarkPosition.RIGHT;
        AquaUIPainter.SliderWidget sliderWidget = this.getSliderWidget();
        SliderLayoutConfiguration sliderLayoutConfiguration = new SliderLayoutConfiguration(sliderWidget, this.sizeVariant, n3, tickMarkPosition);
        LayoutInfo layoutInfo = this.painter.getLayoutInfo().getLayoutInfo(sliderLayoutConfiguration);
        this.fixedWidth = (int)Math.ceil(layoutInfo.getFixedVisualWidth());
        this.fixedHeight = (int)Math.ceil(layoutInfo.getFixedVisualHeight());
        if (n != 0) {
            if (this.fixedHeight == 0) {
                this.fixedHeight = 23;
            }
        } else if (this.fixedWidth == 0) {
            this.fixedWidth = 23;
        }
    }

    protected AquaUIPainter.SliderWidget getSliderWidget() {
        boolean bl = this.slider.getOrientation() == 0;
        boolean bl2 = this.drawInverted();
        return bl ? (bl2 ? AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL_RIGHT_TO_LEFT : AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL) : (bl2 ? AquaUIPainter.SliderWidget.SLIDER_UPSIDE_DOWN : AquaUIPainter.SliderWidget.SLIDER_VERTICAL);
    }

    @Override
    public Shape getFocusRingOutline(JComponent jComponent) {
        SliderPainter sliderPainter = this.getConfiguredPainter();
        Shape shape = sliderPainter.getThumbOutline();
        return ExpandableOutline.createTranslatedShape(shape, this.trackRect.x, this.trackRect.y);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        boolean bl;
        this.recalculateIfInsetsChanged();
        Rectangle rectangle = graphics.getClipBounds();
        if (this.slider.getPaintTrack() && !(bl = rectangle.intersects(this.trackRect))) {
            this.calculateGeometry();
        }
        SliderPainter sliderPainter = this.getConfiguredPainter();
        sliderPainter.paint(graphics, this.trackRect.x, this.trackRect.y);
        if (this.slider.getPaintLabels() && rectangle.intersects(this.labelRect)) {
            this.paintLabels(graphics);
        }
    }

    protected SliderPainter getConfiguredPainter() {
        this.painter.configure(this.trackRect.width, this.trackRect.height);
        SliderConfiguration sliderConfiguration = this.getConfiguration();
        return (SliderPainter)this.painter.getPainter(sliderConfiguration);
    }

    protected SliderConfiguration getConfiguration() {
        int n;
        AquaUIPainter.State state = this.getState();
        int n2 = this.slider.getMaximum() - this.slider.getMinimum();
        int n3 = 0;
        if (this.slider.getPaintTicks() && n2 > 0 && (n = this.getTickSpacing()) > 0) {
            n3 = n2 / n + 1;
        }
        double d = n2 > 0 ? (double)this.slider.getValue() / (double)n2 : 0.0;
        AquaUIPainter.SliderWidget sliderWidget = this.getSliderWidget();
        AquaUIPainter.TickMarkPosition tickMarkPosition = this.getTickMarkPosition();
        boolean bl = this.slider.hasFocus();
        return new SliderConfiguration(sliderWidget, this.sizeVariant, state, bl, d, n3, tickMarkPosition);
    }

    AquaUIPainter.TickMarkPosition getTickMarkPosition() {
        boolean bl;
        boolean bl2 = this.slider.getComponentOrientation().isLeftToRight();
        boolean bl3 = bl = this.slider.getOrientation() == 0;
        if (bl) {
            return AquaUIPainter.TickMarkPosition.BELOW;
        }
        return bl2 ? AquaUIPainter.TickMarkPosition.RIGHT : AquaUIPainter.TickMarkPosition.LEFT;
    }

    AquaUIPainter.State getState() {
        if (!this.slider.isEnabled()) {
            return AquaFocusHandler.isActive(this.slider) ? AquaUIPainter.State.DISABLED : AquaUIPainter.State.DISABLED_INACTIVE;
        }
        if (this.fIsDragging) {
            return AquaUIPainter.State.PRESSED;
        }
        if (!AquaFocusHandler.isActive(this.slider)) {
            return AquaUIPainter.State.INACTIVE;
        }
        return AquaUIPainter.State.ACTIVE;
    }

    @Override
    public void paintTrack(Graphics graphics) {
    }

    @Override
    public void paintThumb(Graphics graphics) {
    }

    @Override
    public void paintTicks(Graphics graphics) {
    }

    @Override
    protected void calculateGeometry() {
        this.updateFixedDimension();
        super.calculateGeometry();
        AquaFocusRingManager.focusRingOutlineChanged(this.slider);
    }

    @Override
    protected int getTickLength() {
        return 0;
    }

    @Override
    protected void calculateThumbLocation() {
        super.calculateThumbLocation();
        SliderPainter sliderPainter = this.getConfiguredPainter();
        this.thumbRect.setBounds(AquaUtils.toRectangle(sliderPainter.getThumbBounds()));
        AquaFocusRingManager.focusRingOutlineChanged(this.slider);
    }

    @Override
    protected void calculateThumbSize() {
        if (this.slider.getOrientation() == 0) {
            this.thumbRect.x = 0;
            this.thumbRect.y = 0;
            this.thumbRect.width = 20;
            this.thumbRect.height = this.fixedHeight > 0 ? this.fixedHeight : 23;
        } else {
            this.thumbRect.x = 0;
            this.thumbRect.y = 0;
            this.thumbRect.width = this.fixedWidth > 0 ? this.fixedWidth : 23;
            this.thumbRect.height = 20;
        }
    }

    @Override
    protected void calculateTrackRect() {
        if (this.slider.getOrientation() == 0) {
            int n = this.thumbRect.height;
            if (this.slider.getPaintTicks()) {
                n += this.getTickLength();
            }
            if (this.slider.getPaintLabels()) {
                n += this.getHeightOfTallestLabel();
            }
            this.trackRect.x = this.contentRect.x + this.leftTrackBuffer;
            this.trackRect.y = this.contentRect.y + (this.contentRect.height - n - 1) / 2;
            this.trackRect.width = this.contentRect.width - this.leftTrackBuffer - this.rightTrackBuffer;
            this.trackRect.height = this.thumbRect.height;
        } else {
            int n = this.thumbRect.width;
            if (this.slider.getComponentOrientation().isLeftToRight()) {
                if (this.slider.getPaintTicks()) {
                    n += this.getTickLength();
                }
                if (this.slider.getPaintLabels()) {
                    n += this.getWidthOfWidestLabel();
                }
            } else {
                if (this.slider.getPaintTicks()) {
                    n -= this.getTickLength();
                }
                if (this.slider.getPaintLabels()) {
                    n -= this.getWidthOfWidestLabel();
                }
            }
            this.trackRect.x = this.contentRect.x + (this.contentRect.width - n - 1) / 2;
            this.trackRect.y = this.contentRect.y + this.leftTrackBuffer;
            this.trackRect.width = this.thumbRect.width;
            this.trackRect.height = this.contentRect.height - this.leftTrackBuffer - this.rightTrackBuffer;
        }
    }

    @Override
    protected void calculateTrackBuffer() {
        this.leftTrackBuffer = 0;
        this.rightTrackBuffer = 0;
        if (this.slider.getPaintLabels() && this.slider.getLabelTable() != null) {
            Rectangle rectangle;
            this.trackRect.width = this.contentRect.width;
            this.trackRect.height = this.contentRect.height;
            SliderPainter sliderPainter = this.getConfiguredPainter();
            int n = this.getLowestValue();
            int n2 = this.getHighestValue();
            double d = this.toThumbPosition(n);
            double d2 = this.toThumbPosition(n2);
            Component component = (Component)this.slider.getLabelTable().get(n);
            Rectangle rectangle2 = AquaUtils.toRectangle(sliderPainter.getLabelBounds(d, component.getSize()));
            Component component2 = (Component)this.slider.getLabelTable().get(n2);
            Rectangle rectangle3 = AquaUtils.toRectangle(sliderPainter.getLabelBounds(d2, component2.getSize()));
            boolean bl = this.drawInverted();
            boolean bl2 = this.slider.getOrientation() == 0;
            Rectangle rectangle4 = bl2 ^ bl ? rectangle2 : rectangle3;
            Rectangle rectangle5 = rectangle = bl2 ^ bl ? rectangle3 : rectangle2;
            if (bl2) {
                this.leftTrackBuffer = Math.max(this.leftTrackBuffer, -rectangle4.x);
                this.rightTrackBuffer = Math.max(this.rightTrackBuffer, rectangle.x + rectangle.width - this.trackRect.width);
            } else {
                this.leftTrackBuffer = Math.max(this.leftTrackBuffer, -rectangle4.y);
                this.rightTrackBuffer = Math.max(this.rightTrackBuffer, rectangle.y + rectangle.height - this.trackRect.height);
            }
        }
        this.trackBuffer = Math.max(this.leftTrackBuffer, this.rightTrackBuffer);
        boolean bl = true;
        if (bl) {
            this.leftTrackBuffer = this.trackBuffer;
            this.rightTrackBuffer = this.trackBuffer;
        }
    }

    protected double toThumbPosition(int n) {
        int n2 = this.slider.getMinimum();
        int n3 = this.slider.getMaximum();
        double d = n3 - n2;
        if (d > 0.0) {
            return (double)n2 + (double)n / d;
        }
        return 0.0;
    }

    @Override
    protected int getWidthOfWidestLabel() {
        int n = super.getWidthOfWidestLabel();
        return n > 0 ? n + 2 : 0;
    }

    @Override
    protected int getHeightOfTallestLabel() {
        int n = super.getHeightOfTallestLabel();
        return n > 0 ? n + 2 : 0;
    }

    @Override
    public Dimension getPreferredHorizontalSize() {
        return new Dimension(190, 21);
    }

    @Override
    public Dimension getPreferredVerticalSize() {
        return new Dimension(21, 190);
    }

    @Override
    public void setThumbLocation(int n, int n2) {
        this.thumbRect.setLocation(n, n2);
        this.slider.repaint();
        AquaFocusRingManager.focusRingOutlineChanged(this.slider);
    }

    @Override
    protected ChangeListener createChangeListener(JSlider jSlider) {
        return new StateChangeListener();
    }

    protected void updateSliderFromLocation(int n, int n2) {
        SliderPainter sliderPainter = this.getConfiguredPainter();
        double d = sliderPainter.getThumbPosition(n - this.trackRect.x, n2 - this.trackRect.y);
        double d2 = this.slider.getMaximum() - this.slider.getMinimum();
        int n3 = (int)((double)this.slider.getMinimum() + d * d2);
        this.slider.setValue(n3);
        sliderPainter = this.getConfiguredPainter();
        this.thumbRect.setBounds(AquaUtils.toRectangle(sliderPainter.getThumbBounds()));
        this.slider.repaint();
        AquaFocusRingManager.focusRingOutlineChanged(this.slider);
    }

    @Override
    public void paintLabels(Graphics graphics) {
        double d = this.slider.getMaximum() - this.slider.getMinimum();
        if (d <= 0.0) {
            return;
        }
        Dictionary dictionary = this.slider.getLabelTable();
        if (dictionary != null) {
            SliderPainter sliderPainter = this.getConfiguredPainter();
            Enumeration enumeration = dictionary.keys();
            int n = this.slider.getMinimum();
            int n2 = this.slider.getMaximum();
            boolean bl = this.slider.isEnabled();
            while (enumeration.hasMoreElements()) {
                Integer n3 = (Integer)enumeration.nextElement();
                int n4 = n3;
                if (n4 < n || n4 > n2) continue;
                JComponent jComponent = (JComponent)dictionary.get(n3);
                jComponent.setEnabled(bl);
                if (jComponent instanceof JLabel) {
                    Icon icon;
                    Icon icon2 = icon = jComponent.isEnabled() ? ((JLabel)jComponent).getIcon() : ((JLabel)jComponent).getDisabledIcon();
                    if (icon instanceof ImageIcon) {
                        Toolkit.getDefaultToolkit().checkImage(((ImageIcon)icon).getImage(), -1, -1, this.slider);
                    }
                }
                double d2 = (double)(n4 - this.slider.getMinimum()) / d;
                Dimension dimension = jComponent.getPreferredSize();
                Rectangle rectangle = AquaUtils.toRectangle(sliderPainter.getLabelBounds(d2, dimension));
                graphics.translate(this.trackRect.x + rectangle.x, this.trackRect.y + rectangle.y);
                jComponent.paint(graphics);
                graphics.translate(-(this.trackRect.x + rectangle.x), -(this.trackRect.y + rectangle.y));
            }
        }
    }

    @Override
    protected void paintHorizontalLabel(Graphics graphics, int n, Component component) {
        double d = this.slider.getMaximum() - this.slider.getMinimum();
        if (d > 0.0) {
            double d2 = (double)(n - this.slider.getMinimum()) / d;
            Dimension dimension = component.getPreferredSize();
            SliderPainter sliderPainter = this.getConfiguredPainter();
            Rectangle rectangle = AquaUtils.toRectangle(sliderPainter.getLabelBounds(d2, dimension));
            graphics.translate(this.trackRect.x + rectangle.x, this.trackRect.y + rectangle.y - this.labelRect.y);
            component.paint(graphics);
            graphics.translate(-(this.trackRect.x + rectangle.x), -(this.trackRect.y + rectangle.y - this.labelRect.y));
        }
    }

    @Override
    protected void paintVerticalLabel(Graphics graphics, int n, Component component) {
        double d = this.slider.getMaximum() - this.slider.getMinimum();
        if (d > 0.0) {
            double d2 = (double)(n - this.slider.getMinimum()) / d;
            Dimension dimension = component.getPreferredSize();
            SliderPainter sliderPainter = this.getConfiguredPainter();
            Rectangle rectangle = AquaUtils.toRectangle(sliderPainter.getLabelBounds(d2, dimension));
            graphics.translate(this.trackRect.x + rectangle.x - this.labelRect.x, this.trackRect.y + rectangle.y);
            component.paint(graphics);
            graphics.translate(-(this.trackRect.x + rectangle.x - this.labelRect.x), -(this.trackRect.y + rectangle.y));
        }
    }

    protected int getTickSpacing() {
        int n = this.slider.getMajorTickSpacing();
        int n2 = this.slider.getMinorTickSpacing();
        int n3 = n2 > 0 ? n2 : (n > 0 ? n : 0);
        return n3;
    }

    class TrackListener
    extends BasicSliderUI.TrackListener {
        protected transient int offset;
        protected transient int currentMouseX;
        protected transient int currentMouseY;

        TrackListener() {
            super(AquaSliderUI.this);
            this.currentMouseX = -1;
            this.currentMouseY = -1;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!AquaSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = -1;
            this.currentMouseY = -1;
            this.offset = 0;
            AquaSliderUI.this.scrollTimer.stop();
            if (AquaSliderUI.this.slider.getSnapToTicks()) {
                AquaSliderUI.this.fIsDragging = false;
                AquaSliderUI.this.slider.setValueIsAdjusting(false);
            } else {
                AquaSliderUI.this.slider.setValueIsAdjusting(false);
                AquaSliderUI.this.fIsDragging = false;
            }
            AquaSliderUI.this.slider.repaint();
            AquaFocusRingManager.focusRingOutlineChanged(AquaSliderUI.this.slider);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!AquaSliderUI.this.slider.isEnabled()) {
                return;
            }
            AquaSliderUI.this.calculateGeometry();
            boolean bl = this.currentMouseX == -1 && this.currentMouseY == -1;
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (AquaSliderUI.this.slider.isRequestFocusEnabled()) {
                AquaSliderUI.this.slider.requestFocus();
            }
            boolean bl2 = AquaSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY);
            if (!bl || !bl2) {
                AquaSliderUI.this.slider.setValueIsAdjusting(true);
                AquaSliderUI.this.updateSliderFromLocation(this.currentMouseX, this.currentMouseY);
                AquaSliderUI.this.slider.setValueIsAdjusting(false);
                bl2 = true;
            }
            if (bl2) {
                switch (AquaSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - ((AquaSliderUI)AquaSliderUI.this).thumbRect.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - ((AquaSliderUI)AquaSliderUI.this).thumbRect.x;
                    }
                }
                AquaSliderUI.this.fIsDragging = true;
                AquaSliderUI.this.slider.repaint();
                return;
            }
            AquaSliderUI.this.fIsDragging = false;
        }

        @Override
        public boolean shouldScroll(int n) {
            Rectangle rectangle = AquaSliderUI.this.thumbRect;
            if (AquaSliderUI.this.slider.getOrientation() == 1 ? ((AquaSliderUI.this.drawInverted() ? n < 0 : n > 0) ? rectangle.y + rectangle.height <= this.currentMouseY : rectangle.y >= this.currentMouseY) : ((AquaSliderUI.this.drawInverted() ? n < 0 : n > 0) ? rectangle.x + rectangle.width >= this.currentMouseX : rectangle.x <= this.currentMouseX)) {
                return false;
            }
            if (n > 0 && AquaSliderUI.this.slider.getValue() + AquaSliderUI.this.slider.getExtent() >= AquaSliderUI.this.slider.getMaximum()) {
                return false;
            }
            return n >= 0 || AquaSliderUI.this.slider.getValue() > AquaSliderUI.this.slider.getMinimum();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!AquaSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (!AquaSliderUI.this.fIsDragging) {
                return;
            }
            AquaSliderUI.this.slider.setValueIsAdjusting(true);
            AquaSliderUI.this.updateSliderFromLocation(this.currentMouseX, this.currentMouseY);
            if (AquaSliderUI.this.slider.getSnapToTicks()) {
                AquaSliderUI.this.calculateThumbLocation();
                AquaSliderUI.this.setThumbLocation(((AquaSliderUI)AquaSliderUI.this).thumbRect.x, ((AquaSliderUI)AquaSliderUI.this).thumbRect.y);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    protected class StateChangeListener
    implements ChangeListener {
        protected StateChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (AquaSliderUI.this.fIsDragging) {
                return;
            }
            AquaSliderUI.this.calculateThumbLocation();
            AquaSliderUI.this.slider.repaint();
            AquaFocusRingManager.focusRingOutlineChanged(AquaSliderUI.this.slider);
        }
    }
}

