/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SeparatorUI;

public class AquaSeparatorUI
extends SeparatorUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaSeparatorUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.installDefaults((JSeparator)jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults((JSeparator)jComponent);
    }

    protected void installDefaults(JSeparator jSeparator) {
        LookAndFeel.installColors(jSeparator, "Separator.background", "Separator.foreground");
        LookAndFeel.installProperty(jSeparator, "opaque", Boolean.FALSE);
    }

    protected void uninstallDefaults(JSeparator jSeparator) {
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Dimension dimension = jComponent.getSize();
        Insets insets = jComponent.getInsets();
        graphics.setColor(jComponent.getForeground());
        if (((JSeparator)jComponent).getOrientation() == 1) {
            graphics.drawLine(insets.left, insets.top, insets.left, dimension.height - insets.bottom - 1);
        } else {
            graphics.drawLine(insets.left, insets.top, dimension.width - insets.right - 1, insets.top);
        }
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Insets insets = jComponent.getInsets();
        if (((JSeparator)jComponent).getOrientation() == 1) {
            return new Dimension(1 + insets.left + insets.right, insets.top + insets.bottom);
        }
        return new Dimension(insets.left + insets.right, 1 + insets.top + insets.bottom);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        if (((JSeparator)jComponent).getOrientation() == 1) {
            dimension.height = Integer.MAX_VALUE;
        } else {
            dimension.width = Integer.MAX_VALUE;
        }
        return dimension;
    }
}

