/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneLayout;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.violetlib.aqua.AquaScrollPaneUI;
import org.violetlib.aqua.AquaUtils;

public class AquaOverlayScrollPaneLayout
extends ScrollPaneLayout
implements UIResource {
    protected boolean isHorizontalScrollBarNeeded;
    protected boolean isVerticalScrollBarNeeded;

    public boolean isHorizontalScrollBarNeeded() {
        return this.isHorizontalScrollBarNeeded;
    }

    public boolean isVerticalScrollBarNeeded() {
        return this.isVerticalScrollBarNeeded;
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        this.sync(container);
        return super.preferredLayoutSize(container);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        this.sync(container);
        return super.minimumLayoutSize(container);
    }

    protected void sync(Container container) {
        JScrollPane jScrollPane = (JScrollPane)container;
        this.vsbPolicy = jScrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = jScrollPane.getHorizontalScrollBarPolicy();
        this.vsb = jScrollPane.getVerticalScrollBar();
        this.hsb = jScrollPane.getHorizontalScrollBar();
        this.viewport = jScrollPane.getViewport();
    }

    @Override
    public void layoutContainer(Container container) {
        int n;
        Insets insets;
        Border border;
        JScrollPane jScrollPane = (JScrollPane)container;
        this.sync(container);
        Rectangle rectangle = jScrollPane.getBounds();
        rectangle.y = 0;
        rectangle.x = 0;
        Insets insets2 = container.getInsets();
        rectangle.x = insets2.left;
        rectangle.y = insets2.top;
        rectangle.width -= insets2.left + insets2.right;
        rectangle.height -= insets2.top + insets2.bottom;
        boolean bl = !AquaScrollPaneUI.isRTLSupported || AquaUtils.isLeftToRight(jScrollPane);
        Rectangle rectangle2 = new Rectangle(0, rectangle.y, 0, 0);
        if (this.colHead != null && this.colHead.isVisible()) {
            int n2;
            rectangle2.height = n2 = Math.min(rectangle.height, this.colHead.getPreferredSize().height);
            rectangle.y += n2;
            rectangle.height -= n2;
        }
        Rectangle rectangle3 = new Rectangle(0, 0, 0, 0);
        if (this.rowHead != null && this.rowHead.isVisible()) {
            int n3;
            rectangle3.width = n3 = Math.min(rectangle.width, this.rowHead.getPreferredSize().width);
            rectangle.width -= n3;
            if (bl) {
                rectangle3.x = rectangle.x;
                rectangle.x += n3;
            } else {
                rectangle3.x = rectangle.x + rectangle.width;
            }
        }
        if ((border = jScrollPane.getViewportBorder()) != null) {
            insets = border.getBorderInsets(container);
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
        } else {
            insets = new Insets(0, 0, 0, 0);
        }
        this.determineScrollBarsNeeded(rectangle);
        if (this.viewport != null) {
            this.viewport.setBounds(rectangle);
        }
        rectangle3.height = rectangle.height + insets.top + insets.bottom;
        rectangle3.y = rectangle.y - insets.top;
        rectangle2.width = rectangle.width + insets.left + insets.right;
        rectangle2.x = rectangle.x - insets.left;
        if (this.rowHead != null) {
            this.rowHead.setBounds(rectangle3);
        }
        if (this.colHead != null) {
            this.colHead.setBounds(rectangle2);
        }
        if (this.vsb != null) {
            if (this.isVerticalScrollBarNeeded) {
                n = this.vsb.getPreferredSize().width;
                this.vsb.setBounds(bl ? rectangle.x + rectangle.width - n : rectangle.x, rectangle.y, n, rectangle.height);
            } else {
                this.vsb.setBounds(0, 0, 0, 0);
            }
        }
        if (this.hsb != null) {
            if (this.isHorizontalScrollBarNeeded) {
                n = this.hsb.getPreferredSize().height;
                this.hsb.setBounds(rectangle.x, rectangle.y + rectangle.height - n, rectangle.width, n);
            } else {
                this.hsb.setBounds(0, 0, 0, 0);
            }
        }
        int n4 = n = this.rowHead != null && this.colHead != null && this.rowHead.isVisible() && this.colHead.isVisible() ? 1 : 0;
        if (this.lowerLeft != null) {
            this.lowerLeft.setBounds(0, 0, 0, 0);
        }
        if (this.lowerRight != null) {
            this.lowerRight.setBounds(0, 0, 0, 0);
        }
        if (this.upperLeft != null) {
            if (n != 0 && bl) {
                this.upperLeft.setBounds(rectangle3.x, rectangle2.y, rectangle3.width, rectangle2.height);
            } else {
                this.upperLeft.setBounds(0, 0, 0, 0);
            }
        }
        if (this.upperRight != null) {
            if (n != 0 && !bl) {
                this.upperRight.setBounds(rectangle3.x, rectangle2.y, rectangle3.width, rectangle2.height);
            } else {
                this.upperRight.setBounds(0, 0, 0, 0);
            }
        }
    }

    protected void determineScrollBarsNeeded(Rectangle rectangle) {
        boolean bl;
        Component component = this.viewport != null ? SwingUtilities.getUnwrappedView(this.viewport) : null;
        Dimension dimension = component != null ? component.getPreferredSize() : new Dimension(0, 0);
        Dimension dimension2 = this.viewport != null ? this.viewport.toViewCoordinates(rectangle.getSize()) : new Dimension(0, 0);
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = bl = rectangle.width < 0 || rectangle.height < 0;
        if (!bl && component instanceof Scrollable) {
            Scrollable scrollable = (Scrollable)((Object)component);
            bl2 = scrollable.getScrollableTracksViewportWidth();
            bl3 = scrollable.getScrollableTracksViewportHeight();
        }
        this.isVerticalScrollBarNeeded = false;
        this.isHorizontalScrollBarNeeded = false;
        if (this.vsb != null && !bl && this.vsbPolicy != 21) {
            boolean bl5 = this.isVerticalScrollBarNeeded = !bl3 && dimension.height > dimension2.height;
        }
        if (this.hsb != null && !bl && this.hsbPolicy != 31) {
            this.isHorizontalScrollBarNeeded = !bl2 && dimension.width > dimension2.width;
        }
    }
}

