/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicOptionPaneUI;
import javax.swing.text.Document;
import sun.swing.DefaultLookup;

public class AquaOptionPaneUI
extends BasicOptionPaneUI {
    private static final int kOKCancelButtonWidth = 79;
    private static final int kButtonHeight = 23;
    private static final int kDialogSmallPadding = 4;
    private static final int kDialogLargePadding = 23;
    public static final String TEXT_FIELD_DOCUMENT_KEY = "JOptionPane.textFieldDocument";
    private static String newline = System.lineSeparator();

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaOptionPaneUI();
    }

    @Override
    protected Container createButtonArea() {
        Container container = super.createButtonArea();
        container.setLayout(new AquaButtonAreaLayout(true, 4));
        return container;
    }

    @Override
    protected Container createMessageArea() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(UIManager.getBorder("OptionPane.messageAreaBorder"));
        jPanel.setLayout(new BorderLayout());
        JComponent jComponent = this.createIconPanel();
        JComponent jComponent2 = this.createBody();
        jComponent2.setName("OptionPane.body");
        if (jComponent != null) {
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setName("OptionPane.realBody");
            jPanel2.add(Box.createHorizontalStrut(23), "Before");
            jPanel2.add((Component)jComponent2, "Center");
            jPanel.add((Component)jPanel2, "Center");
            jPanel.add((Component)jComponent, "Before");
        } else {
            jPanel.add((Component)jComponent2, "Center");
        }
        return jPanel;
    }

    protected JComponent createIconPanel() {
        Icon icon = this.getIcon();
        if (icon != null) {
            JLabel jLabel = new JLabel(icon);
            jLabel.setVerticalAlignment(1);
            JPanel jPanel = new JPanel();
            jPanel.add(jLabel);
            return jPanel;
        }
        return null;
    }

    protected JComponent createBody() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.addMessageComponents(jPanel, gridBagConstraints, this.getMessage(), this.getMaxCharactersPerLineCount(), false);
        return jPanel;
    }

    @Override
    protected int getMaxCharactersPerLineCount() {
        return this.optionPane.getMaxCharactersPerLineCount();
    }

    @Override
    protected Object getMessage() {
        Object object;
        Object object2 = super.getMessage();
        if (object2 != null && this.inputComponent instanceof JTextField && (object = this.optionPane.getClientProperty(TEXT_FIELD_DOCUMENT_KEY)) instanceof Document) {
            Document document = (Document)object;
            JTextField jTextField = (JTextField)this.inputComponent;
            jTextField.setDocument(document);
        }
        return object2;
    }

    @Override
    protected void addMessageComponents(Container container, GridBagConstraints gridBagConstraints, Object object, int n, boolean bl) {
        if (object == null) {
            return;
        }
        if (object instanceof Component) {
            if (object instanceof JScrollPane || object instanceof JPanel) {
                gridBagConstraints.fill = 1;
                gridBagConstraints.weighty = 1.0;
            } else {
                gridBagConstraints.fill = 2;
            }
            gridBagConstraints.weightx = 1.0;
            container.add((Component)object, gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            ++gridBagConstraints.gridy;
            if (!bl) {
                this.hasCustomComponents = true;
            }
        } else if (object instanceof Object[]) {
            Object[] objectArray;
            for (Object object2 : objectArray = (Object[])object) {
                this.addMessageComponents(container, gridBagConstraints, object2, n, false);
            }
        } else if (object instanceof Icon) {
            JLabel jLabel = new JLabel((Icon)object, 0);
            this.configureMessageLabel(jLabel);
            this.addMessageComponents(container, gridBagConstraints, jLabel, n, true);
        } else {
            String string = object.toString();
            int n2 = string.length();
            if (n2 <= 0) {
                return;
            }
            if (string.startsWith("<html>")) {
                JComponent jComponent = this.createHTMLTextComponent(string, n);
                jComponent.setName("OptionPane.label");
                this.configureMessageLabel(jComponent);
                this.addMessageComponents(container, gridBagConstraints, jComponent, n, true);
                return;
            }
            int n3 = 0;
            int n4 = string.indexOf(newline);
            if (n4 >= 0) {
                n3 = newline.length();
            } else {
                n4 = string.indexOf("\r\n");
                if (n4 >= 0) {
                    n3 = 2;
                } else {
                    n4 = string.indexOf(10);
                    if (n4 >= 0) {
                        n3 = 1;
                    }
                }
            }
            if (n4 >= 0) {
                if (n4 == 0) {
                    JPanel jPanel = new JPanel(){

                        @Override
                        public Dimension getPreferredSize() {
                            Font font = this.getFont();
                            if (font != null) {
                                return new Dimension(1, font.getSize() + 2);
                            }
                            return new Dimension(0, 0);
                        }
                    };
                    jPanel.setName("OptionPane.break");
                    this.addMessageComponents(container, gridBagConstraints, jPanel, n, true);
                } else {
                    this.addMessageComponents(container, gridBagConstraints, string.substring(0, n4), n, false);
                }
                this.addMessageComponents(container, gridBagConstraints, string.substring(n4 + n3), n, false);
            } else {
                JComponent jComponent = this.createTextComponent(string, n);
                jComponent.setName("OptionPane.label");
                this.configureMessageLabel(jComponent);
                this.addMessageComponents(container, gridBagConstraints, jComponent, n, true);
            }
        }
    }

    protected JComponent createHTMLTextComponent(String string, int n) {
        if (n > 100000) {
            n = 80;
        }
        int n2 = 15 * Math.max(n, 100);
        JLabel jLabel = new JLabel(string, 10);
        jLabel.setMaximumSize(new Dimension(n2, 10000));
        return jLabel;
    }

    protected JComponent createTextComponent(String string, int n) {
        if (n > 100000) {
            n = 80;
        }
        if (string.length() < n) {
            return new JLabel(string, 10);
        }
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setBackground(UIManager.getColor("Label.background"));
        jTextArea.setFont(UIManager.getFont("Label.font"));
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setColumns(n);
        jTextArea.setText(string);
        jTextArea.setSize(n * 15, 10000);
        return jTextArea;
    }

    protected void configureMessageLabel(JComponent jComponent) {
        Font font;
        Color color = (Color)DefaultLookup.get(this.optionPane, this, "OptionPane.messageForeground");
        if (color != null) {
            jComponent.setForeground(color);
        }
        if ((font = (Font)DefaultLookup.get(this.optionPane, this, "OptionPane.messageFont")) != null) {
            jComponent.setFont(font);
        }
    }

    static {
        if (newline == null) {
            newline = "\n";
        }
    }

    public static class AquaButtonAreaLayout
    extends BasicOptionPaneUI.ButtonAreaLayout {
        public AquaButtonAreaLayout(boolean bl, int n) {
            super(true, n);
        }

        @Override
        public void layoutContainer(Container container) {
            int n;
            Component[] componentArray = container.getComponents();
            if (componentArray == null || 0 >= componentArray.length) {
                return;
            }
            int n2 = componentArray.length;
            int n3 = container.getInsets().top;
            Dimension dimension = new Dimension(79, 23);
            for (n = 0; n < n2; ++n) {
                Dimension dimension2 = componentArray[n].getPreferredSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                dimension.height = Math.max(dimension.height, dimension2.height);
            }
            n = container.getSize().width - (dimension.width * n2 + (n2 - 1) * this.padding);
            int n4 = dimension.width + this.padding;
            for (int i = n2 - 1; i >= 0; --i) {
                componentArray[i].setBounds(n, n3, dimension.width, dimension.height);
                n += n4;
            }
        }
    }
}

