/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageFilter;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.WritableRaster;
import org.violetlib.aqua.Aqua18MultiResolutionImage;
import org.violetlib.aqua.Aqua18MultiResolutionImage2;
import sun.awt.image.SunWritableRaster;

public abstract class AquaMultiResolutionImage
extends Image {
    protected final Image baseImage;
    protected final int baseImageWidth;
    protected final int baseImageHeight;

    public static Image createImage2x(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth() / 2;
        int n2 = bufferedImage.getHeight() / 2;
        return new Aqua18MultiResolutionImage(n, n2, bufferedImage);
    }

    public static Image createImage(int n, int n2, int[] nArray, int[] nArray2) {
        BufferedImage bufferedImage = AquaMultiResolutionImage.createImage(n, n2, nArray);
        if (nArray2 != null) {
            BufferedImage bufferedImage2 = AquaMultiResolutionImage.createImage(n * 2, n2 * 2, nArray2);
            return new Aqua18MultiResolutionImage2(bufferedImage, bufferedImage2);
        }
        return new Aqua18MultiResolutionImage(bufferedImage);
    }

    private static BufferedImage createImage(int n, int n2, int[] nArray) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 3);
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray2 = SunWritableRaster.stealData(dataBufferInt, 0);
        System.arraycopy(nArray, 0, nArray2, 0, n * n2);
        SunWritableRaster.markDirty(dataBufferInt);
        return bufferedImage;
    }

    public static Image apply(Image image, Mapper mapper) {
        return Aqua18MultiResolutionImage.apply(image, mapper);
    }

    public static Image apply(Image image, ImageFilter imageFilter) {
        return Aqua18MultiResolutionImage.apply(image, imageFilter);
    }

    protected AquaMultiResolutionImage(Image image) {
        this.baseImage = image;
        this.baseImageWidth = image.getWidth(null);
        this.baseImageHeight = image.getHeight(null);
    }

    protected AquaMultiResolutionImage(Image image, int n, int n2) {
        this.baseImage = image;
        this.baseImageWidth = n;
        this.baseImageHeight = n2;
    }

    public abstract AquaMultiResolutionImage map(Mapper var1);

    @Override
    public int getWidth(ImageObserver imageObserver) {
        return this.baseImageWidth;
    }

    @Override
    public int getHeight(ImageObserver imageObserver) {
        return this.baseImageHeight;
    }

    @Override
    public Object getProperty(String string, ImageObserver imageObserver) {
        return this.baseImage.getProperty(string, imageObserver);
    }

    @Override
    public ImageProducer getSource() {
        return this.baseImage.getSource();
    }

    @Override
    public Graphics getGraphics() {
        throw new UnsupportedOperationException();
    }

    public static interface Mapper {
        public Image map(Image var1, int var2);
    }
}

