/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import com.apple.eio.FileManager;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.UIResource;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaMultiResolutionImage;
import org.violetlib.aqua.AquaNativeSupport;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.jnr.Painter;

public class AquaIcon {
    public static final IconImageCreator alertCautionImageCreator = new IconImageCreator("caut", 64);
    public static final IconImageCreator alertStopImageCreator = new IconImageCreator("stop", 64);
    public static final IconImageCreator openFolderImageCreator = new IconImageCreator("ofld", 20);
    private static final RecyclableIconImageSingleton cautionIcon = new RecyclableIconImageSingleton(alertCautionImageCreator);
    private static final RecyclableIconImageSingleton stopIcon = new RecyclableIconImageSingleton(alertStopImageCreator);
    private static final RecyclableIconImageSingleton openFolderIcon = new RecyclableIconImageSingleton(openFolderImageCreator);

    public static Icon loadResource(String string) {
        Image image = AquaImageFactory.loadResource(string);
        return new ImageIcon(image);
    }

    public static Image getImageForIcon(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 3);
        Graphics graphics = bufferedImage.getGraphics();
        icon.paintIcon(null, graphics, 0, 0);
        graphics.dispose();
        return bufferedImage;
    }

    public static Image getStopIconImage() {
        return stopIcon.getInstance();
    }

    public static Image getCautionIconImage() {
        return cautionIcon.getInstance();
    }

    public static IconUIResource getOpenFolderIcon() {
        return new IconUIResource(new ImageIcon(openFolderIcon.getInstance()));
    }

    private static native boolean nativeRenderIcon(int var0, int[][] var1, int var2);

    private static class IconImageCreator {
        private final String osTypeName;
        private final int osType;
        private final int size;
        private Image result;

        public IconImageCreator(String string, int n) {
            this.osTypeName = string;
            this.osType = FileManager.OSTypeToInt((String)string);
            this.size = n;
        }

        public Image getImage() {
            if (this.result == null) {
                AquaNativeSupport.load();
                int[][] nArrayArray = new int[2][];
                if (!AquaIcon.nativeRenderIcon(this.osType, nArrayArray, this.size)) {
                    if (AquaImageFactory.debugNativeRendering) {
                        System.err.println("Failed to render image for icon " + this.osTypeName);
                    }
                    throw new UnsupportedOperationException();
                }
                if (AquaImageFactory.debugNativeRendering) {
                    System.err.println("Rendered image for icon " + this.osTypeName);
                }
                this.result = AquaMultiResolutionImage.createImage(this.size, this.size, nArrayArray[0], nArrayArray[1]);
            }
            return this.result;
        }
    }

    public static abstract class ScalingNativeRenderedIcon
    implements Icon,
    UIResource {
        final int width;
        final int height;

        public ScalingNativeRenderedIcon(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (GraphicsEnvironment.isHeadless()) {
                return;
            }
            if ((graphics = graphics.create()) instanceof Graphics2D) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            Painter painter = this.getPainter(this.width, this.height);
            graphics.clipRect(n, n2, this.width, this.height);
            painter.paint(graphics, n, n2);
            graphics.dispose();
        }

        public abstract Painter getPainter(int var1, int var2);

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    public static abstract class CachingScalingIcon
    implements Icon,
    UIResource {
        int width;
        int height;
        Image image;

        public CachingScalingIcon(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        void setSize(int n, int n2) {
            this.width = n;
            this.height = n2;
            this.image = null;
        }

        Image getImage() {
            if (this.image != null) {
                return this.image;
            }
            if (!GraphicsEnvironment.isHeadless()) {
                this.image = this.createImage();
            }
            return this.image;
        }

        abstract Image createImage();

        public boolean hasIconRef() {
            return this.getImage() != null;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Image image;
            if ((graphics = graphics.create()) instanceof Graphics2D) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            if ((image = this.getImage()) != null) {
                graphics.drawImage(image, n, n2, this.getIconWidth(), this.getIconHeight(), null);
            }
            graphics.dispose();
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    private static class RecyclableIconImageSingleton
    extends AquaUtils.RecyclableSingleton<Image> {
        final IconImageCreator imageCreator;

        public RecyclableIconImageSingleton(IconImageCreator iconImageCreator) {
            this.imageCreator = iconImageCreator;
        }

        @Override
        protected Image getInstance() {
            return this.imageCreator.getImage();
        }
    }

    static interface InvertableIcon
    extends Icon {
        public Icon getInvertedIcon();
    }
}

