/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaToolBarUI;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.WindowDraggingMouseListener;

public class AquaCustomStyledWindow {
    public static final int STYLE_NORMAL = 0;
    public static final int STYLE_TRANSPARENT = 1;
    public static final int STYLE_HIDDEN = 2;
    public static final int STYLE_UNIFIED = 3;
    public static final int STYLE_TEXTURED_HIDDEN = 4;
    public static final int STYLE_COMBINED = 5;
    protected final int TITLE_BAR_HEIGHT = 24;
    protected final int TITLE_BAR_BUTTONS_WIDTH = 78;
    protected Window w;
    protected JRootPane rp;
    protected final int style;
    protected final int titleBarStyle;
    protected final boolean isUnifiedStyle;
    protected JComponent contentPane;
    protected JToolBar windowToolBar;
    protected WindowPropertyChangeListener propertyChangeListener;
    protected WindowDraggingMouseListener windowDraggingMouseListener;
    protected HierarchyListener toolbarHierarchyListener;

    public AquaCustomStyledWindow(Window window, int n) throws IllegalArgumentException {
        if (window instanceof JFrame) {
            JFrame jFrame = (JFrame)window;
            if (jFrame.isUndecorated()) {
                throw new IllegalArgumentException("Window is not decorated");
            }
            this.w = window;
            this.rp = jFrame.getRootPane();
        } else if (window instanceof JDialog) {
            JDialog jDialog = (JDialog)window;
            if (jDialog.isUndecorated()) {
                throw new IllegalArgumentException("Window is not decorated");
            }
            this.w = window;
            this.rp = jDialog.getRootPane();
        } else {
            throw new IllegalArgumentException("Window is not decorated");
        }
        switch (n) {
            case 0: {
                this.titleBarStyle = 4;
                this.isUnifiedStyle = false;
                break;
            }
            case 1: {
                this.titleBarStyle = 2;
                this.isUnifiedStyle = false;
                break;
            }
            case 2: {
                this.titleBarStyle = 3;
                this.isUnifiedStyle = false;
                break;
            }
            case 3: {
                this.titleBarStyle = 2;
                this.isUnifiedStyle = true;
                break;
            }
            case 4: {
                this.titleBarStyle = 3;
                this.isUnifiedStyle = true;
                break;
            }
            case 5: {
                this.titleBarStyle = 2;
                this.isUnifiedStyle = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid style");
            }
        }
        this.style = n;
        this.contentPane = this.getContentPane();
        if (this.contentPane == null) {
            throw new IllegalArgumentException("Window content pane is not a Swing component");
        }
        if (this.isUnifiedStyle) {
            this.windowToolBar = this.getWindowToolbar();
            if (this.windowToolBar == null) {
                throw new IllegalArgumentException("Window content pane must contain a non-floatable JToolBar");
            }
            this.setupToolbar(this.windowToolBar);
        }
        this.setupContentPane(this.contentPane);
        if (this.isUnifiedStyle) {
            this.propertyChangeListener = new WindowPropertyChangeListener();
            this.rp.addPropertyChangeListener("Frame.active", this.propertyChangeListener);
        }
        if (n == 5) {
            AquaUtils.setWindowTitle(window, "");
        }
        AquaUtils.setTitleBarStyle(window, this.titleBarStyle);
    }

    public void dispose() {
        if (this.w != null) {
            this.rp.removePropertyChangeListener("Frame.active", this.propertyChangeListener);
            this.propertyChangeListener = null;
            this.rp = null;
            AquaUtils.setTitleBarStyle(this.w, 1);
            if (this.windowToolBar != null) {
                this.resetBorder(this.windowToolBar);
                if (this.toolbarHierarchyListener != null) {
                    this.windowToolBar.removeHierarchyListener(this.toolbarHierarchyListener);
                    this.toolbarHierarchyListener = null;
                }
                if (this.windowDraggingMouseListener != null) {
                    this.windowDraggingMouseListener.detach(this.windowToolBar);
                    this.windowDraggingMouseListener = null;
                }
                this.windowToolBar = null;
            }
            this.resetBorder(this.contentPane);
            this.w = null;
            this.contentPane = null;
        }
    }

    protected void setupContentPane(JComponent jComponent) {
        if (this.style == 0 || this.style == 1) {
            this.installBorder(jComponent, 24, 0, 0, 0);
        } else {
            this.installBorder(jComponent, 0, 0, 0, 0);
        }
        if (this.isUnifiedStyle) {
            jComponent.setOpaque(false);
        }
    }

    protected void setupToolbar(JToolBar jToolBar) {
        jToolBar.setOpaque(false);
        Container container = jToolBar;
        while ((container = container.getParent()) != this.contentPane && container != null) {
            if (!(container instanceof JComponent)) continue;
            ((JComponent)container).setOpaque(false);
        }
        this.installToolbarBorder(jToolBar);
        this.attachWindowDraggingMouseListener(jToolBar);
        this.attachHierarchyListener(jToolBar);
    }

    protected void installToolbarBorder(JToolBar jToolBar) {
        Border border = jToolBar.getBorder();
        if (border == null || border instanceof UIResource) {
            boolean bl = this.isTallFormat(jToolBar);
            if (this.style == 3) {
                int n = bl ? 0 : 4;
                jToolBar.setBorder(new CustomToolbarBorder(n, 24, n, true));
            } else if (this.style == 5) {
                int n = bl ? 0 : 4;
                jToolBar.setBorder(new CustomToolbarBorder(78, n, n, true));
            } else if (this.style == 4) {
                int n = bl ? 0 : 4;
                jToolBar.setBorder(new CustomToolbarBorder(n, n, n, true));
            }
        }
    }

    protected boolean isTallFormat(JToolBar jToolBar) {
        int n = jToolBar.getComponentCount();
        for (int i = 0; i < n; ++i) {
            AbstractButton abstractButton;
            Component component = jToolBar.getComponent(i);
            if (!(component instanceof AbstractButton) || !this.isTallFormat(abstractButton = (AbstractButton)component)) continue;
            return true;
        }
        return false;
    }

    protected boolean isTallFormat(AbstractButton abstractButton) {
        if (abstractButton.getIcon() == null) {
            return false;
        }
        String string = abstractButton.getText();
        if (string == null || string.isEmpty()) {
            return false;
        }
        return abstractButton.getVerticalTextPosition() == 3;
    }

    protected void installBorder(JComponent jComponent, int n, int n2, int n3, int n4) {
        Border border = jComponent.getBorder();
        if (border == null || border instanceof UIResource) {
            jComponent.setBorder(new BorderUIResource.EmptyBorderUIResource(n, n2, n3, n4));
        }
    }

    protected void resetBorder(JComponent jComponent) {
        Border border = jComponent.getBorder();
        if (border == null || border instanceof UIResource) {
            if (jComponent instanceof JToolBar) {
                jComponent.setBorder(AquaToolBarUI.getToolBarBorder());
            } else {
                jComponent.setBorder(null);
            }
        }
    }

    protected void attachWindowDraggingMouseListener(JComponent jComponent) {
        if (jComponent != null && this.windowDraggingMouseListener == null) {
            this.windowDraggingMouseListener = new WindowDraggingMouseListener();
            this.windowDraggingMouseListener.attach(jComponent);
        }
    }

    protected void attachHierarchyListener(JToolBar jToolBar) {
        if (this.toolbarHierarchyListener == null) {
            this.toolbarHierarchyListener = new ToolbarHierarchyListener();
        }
        jToolBar.addHierarchyListener(this.toolbarHierarchyListener);
    }

    public void paintBackground(Graphics graphics) {
        if (this.rp != null && this.isUnifiedStyle) {
            this.paintUnifiedBackground(graphics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintUnifiedBackground(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            int n = this.getTopGradientHeight();
            boolean bl = AquaFocusHandler.isActive(this.rp);
            if (bl) {
                Color color = new Color(230, 230, 230);
                Color color2 = new Color(210, 210, 210);
                GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, 0.0f, n, color2);
                graphics2D.setPaint(gradientPaint);
            } else {
                graphics2D.setColor(new Color(246, 246, 246));
            }
            graphics2D.fillRect(0, 0, this.rp.getWidth(), this.rp.getHeight());
        }
        finally {
            graphics2D.dispose();
        }
    }

    protected int getTopGradientHeight() {
        int n = this.windowToolBar.getHeight();
        switch (this.style) {
            case 3: {
                return n + 24;
            }
            case 5: {
                return Math.max(n, 24);
            }
        }
        return n;
    }

    protected JComponent getContentPane() {
        Container container = this.rp.getContentPane();
        return container instanceof JComponent ? (JComponent)container : null;
    }

    protected JToolBar getWindowToolbar() {
        Container container = this.rp.getContentPane();
        return this.getWindowToolbar(container);
    }

    protected JToolBar getWindowToolbar(Container container) {
        JToolBar jToolBar;
        Component component;
        int n;
        int n2 = container.getComponentCount();
        for (n = 0; n < n2; ++n) {
            component = container.getComponent(n);
            if (!(component instanceof JToolBar) || (jToolBar = (JToolBar)component).isFloatable()) continue;
            return jToolBar;
        }
        for (n = 0; n < n2; ++n) {
            component = container.getComponent(n);
            if (!(component instanceof Container) || (jToolBar = this.getWindowToolbar((Container)component)) == null) continue;
            return jToolBar;
        }
        return null;
    }

    protected class CustomToolbarBorder
    extends AbstractBorder
    implements UIResource {
        protected int extraTop;
        protected int extraLeft;
        protected int extraBottom;
        protected boolean includeBottomLine;

        public CustomToolbarBorder(int n, int n2, int n3, boolean bl) {
            this.extraLeft = n;
            this.extraTop = n2;
            this.extraBottom = n3;
            this.includeBottomLine = bl;
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            JToolBar jToolBar = (JToolBar)component;
            Insets insets2 = jToolBar.getMargin();
            insets.left = insets2.left + this.extraLeft;
            insets.top = insets2.top + this.extraTop;
            insets.right = insets2.right;
            insets.bottom = insets2.bottom + this.extraBottom + (this.includeBottomLine ? 1 : 0);
            return insets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (this.includeBottomLine) {
                graphics.setColor(new Color(186, 186, 186));
                graphics.fillRect(n, n2 + n4 - 1, n3, 1);
            }
        }
    }

    protected class ToolbarHierarchyListener
    implements HierarchyListener {
        protected ToolbarHierarchyListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            JToolBar jToolBar;
            if (hierarchyEvent.getChangeFlags() == 1L && SwingUtilities.getWindowAncestor(jToolBar = (JToolBar)hierarchyEvent.getComponent()) != AquaCustomStyledWindow.this.w) {
                AquaCustomStyledWindow.this.resetBorder(jToolBar);
                if (jToolBar == AquaCustomStyledWindow.this.windowToolBar) {
                    AquaCustomStyledWindow.this.windowToolBar = null;
                }
                jToolBar.removeHierarchyListener(AquaCustomStyledWindow.this.toolbarHierarchyListener);
                if (AquaCustomStyledWindow.this.windowDraggingMouseListener != null) {
                    AquaCustomStyledWindow.this.windowDraggingMouseListener.detach(jToolBar);
                }
            }
        }
    }

    protected class WindowPropertyChangeListener
    implements PropertyChangeListener {
        protected WindowPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AquaCustomStyledWindow.this.rp.repaint();
        }
    }
}

