/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.DefaultButtonModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.violetlib.aqua.AquaButtonExtendedTypes;
import org.violetlib.aqua.AquaCellEditorPolicy;
import org.violetlib.aqua.AquaComboBoxUI;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaPainting;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.jnr.Painter;
import org.violetlib.jnr.aqua.AbstractComboBoxLayoutConfiguration;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ComboBoxConfiguration;
import org.violetlib.jnr.aqua.ComboBoxLayoutConfiguration;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.LayoutConfiguration;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.aqua.PopupButtonLayoutConfiguration;

class AquaComboBoxButton
extends JButton {
    public static final String BUTTON_TYPE = "JButton.buttonType";
    public static final String LAYOUT_CONFIGURATION_PROPERTY = "Aqua.ComboBox.LayoutConfiguration";
    private static AquaCellEditorPolicy cellEditorPolicy = AquaCellEditorPolicy.getInstance();
    private static AquaComboBoxHierarchyListener hierarchyListener = new AquaComboBoxHierarchyListener();
    protected final JComboBox<Object> comboBox;
    protected final JList<?> list;
    protected final CellRendererPane rendererPane;
    protected final AquaComboBoxUI ui;
    protected final AquaButtonExtendedTypes.ColorDefaults colorDefaults;
    protected final AquaUIPainter painter = AquaPainting.create();
    protected boolean isPopDown;
    protected String style;
    protected AquaUIPainter.Size sizeVariant;
    protected boolean isRollover;

    protected AquaComboBoxButton(AquaComboBoxUI aquaComboBoxUI, JComboBox<Object> jComboBox, CellRendererPane cellRendererPane, JList<?> jList) {
        super("");
        this.putClientProperty(BUTTON_TYPE, "comboboxInternal");
        this.ui = aquaComboBoxUI;
        this.comboBox = jComboBox;
        this.rendererPane = cellRendererPane;
        this.list = jList;
        this.colorDefaults = new AquaButtonExtendedTypes.ColorDefaults();
        this.colorDefaults.disabledTextColor = UIManager.getColor("ComboBox.disabledForeground");
        this.colorDefaults.enabledTextColor = UIManager.getColor("ComboBox.foreground");
        this.setModel(new DefaultButtonModel(){

            @Override
            public void setArmed(boolean bl) {
                super.setArmed(this.isPressed() ? true : bl);
            }
        });
        this.setEnabled(jComboBox.isEnabled());
        this.addMouseListener(new RolloverMouseListener());
        this.addHierarchyListener(hierarchyListener);
    }

    @Override
    public boolean isEnabled() {
        return this.comboBox == null ? true : this.comboBox.isEnabled();
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    public void configure(AquaUIPainter.Size size) {
        Object object;
        Object object2 = this.comboBox.getClientProperty("JComboBox.isPopDown");
        this.isPopDown = Boolean.TRUE.equals(object2);
        object2 = null;
        Object object3 = this.comboBox.getClientProperty("JComboBox.style");
        if (object3 instanceof String) {
            object2 = (String)object3;
        } else {
            object3 = this.comboBox.getClientProperty("JComboBox.isSquare");
            if (Boolean.TRUE.equals(object3)) {
                object2 = "old_square";
            }
        }
        this.style = object2;
        if (size != null) {
            this.sizeVariant = size;
        }
        if (this.sizeVariant == null) {
            this.sizeVariant = AquaUIPainter.Size.REGULAR;
        }
        boolean bl = this.comboBox.isEditable();
        AquaUIPainter.UILayoutDirection uILayoutDirection = AquaUtils.getLayoutDirection(this.comboBox);
        if (bl) {
            object = this.getComboBoxWidget();
            object2 = new ComboBoxLayoutConfiguration((AquaUIPainter.ComboBoxWidget)((Object)object), this.sizeVariant, uILayoutDirection);
        } else {
            object = this.getPopupButtonWidget();
            this.sizeVariant = this.canonicalize(this.sizeVariant, (AquaUIPainter.PopupButtonWidget)((Object)object));
            object2 = new PopupButtonLayoutConfiguration((AquaUIPainter.PopupButtonWidget)((Object)object), this.sizeVariant, uILayoutDirection);
        }
        this.comboBox.putClientProperty(LAYOUT_CONFIGURATION_PROPERTY, object2);
        if (AquaUtilControlSize.isOKToInstallDefaultFont(this.comboBox)) {
            object = this.getDefaultFont((LayoutConfiguration)object2);
            AquaUtilControlSize.installDefaultFont(this.comboBox, (Font)object);
        }
        this.comboBox.revalidate();
        this.comboBox.repaint();
    }

    public AbstractComboBoxLayoutConfiguration getLayoutConfiguration() {
        return (AbstractComboBoxLayoutConfiguration)this.comboBox.getClientProperty(LAYOUT_CONFIGURATION_PROPERTY);
    }

    protected AquaUIPainter.Size canonicalize(AquaUIPainter.Size size, AquaUIPainter.PopupButtonWidget popupButtonWidget) {
        switch (popupButtonWidget) {
            case BUTTON_POP_UP_BEVEL: 
            case BUTTON_POP_DOWN_BEVEL: 
            case BUTTON_POP_UP_SQUARE: 
            case BUTTON_POP_DOWN_SQUARE: 
            case BUTTON_POP_UP_GRADIENT: 
            case BUTTON_POP_DOWN_GRADIENT: {
                return AquaUIPainter.Size.REGULAR;
            }
        }
        return size;
    }

    protected Font getDefaultFont(LayoutConfiguration layoutConfiguration) {
        Font font = this.comboBox.getFont();
        Object object = this.getWidget(layoutConfiguration);
        if (object != null) {
            return AquaButtonExtendedTypes.getFont(font, object, this.sizeVariant);
        }
        return font;
    }

    protected Object getWidget(LayoutConfiguration layoutConfiguration) {
        if (layoutConfiguration instanceof ComboBoxLayoutConfiguration) {
            ComboBoxLayoutConfiguration comboBoxLayoutConfiguration = (ComboBoxLayoutConfiguration)layoutConfiguration;
            return comboBoxLayoutConfiguration.getWidget();
        }
        if (layoutConfiguration instanceof PopupButtonLayoutConfiguration) {
            PopupButtonLayoutConfiguration popupButtonLayoutConfiguration = (PopupButtonLayoutConfiguration)layoutConfiguration;
            return popupButtonLayoutConfiguration.getPopupButtonWidget();
        }
        return null;
    }

    protected AquaUIPainter.ComboBoxWidget getComboBoxWidget() {
        boolean bl = cellEditorPolicy.isCellEditor(this.comboBox);
        return bl ? AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL : AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX;
    }

    protected AquaUIPainter.PopupButtonWidget getPopupButtonWidget() {
        boolean bl = cellEditorPolicy.isCellEditor(this.comboBox);
        if (bl) {
            return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_CELL : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_CELL;
        }
        if (this.style != null) {
            switch (this.style) {
                case "tableHeader": 
                case "cell": 
                case "borderless": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_CELL : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_CELL;
                }
                case "square": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_GRADIENT : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_GRADIENT;
                }
                case "old_square": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_SQUARE : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_SQUARE;
                }
                case "bevel": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_BEVEL : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_BEVEL;
                }
                case "roundRect": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_ROUND_RECT : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_ROUND_RECT;
                }
                case "recessed": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_RECESSED : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_RECESSED;
                }
                case "textured": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_TEXTURED : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_TEXTURED;
                }
                case "gradient": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_GRADIENT : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_GRADIENT;
                }
            }
        }
        return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP;
    }

    @Override
    public Color getForeground() {
        if (this.comboBox == null) {
            return super.getForeground();
        }
        Color color = this.comboBox.getForeground();
        if (color == null || color instanceof UIResource) {
            Color color2;
            Object object = this.getWidget(this.getLayoutConfiguration());
            AquaButtonExtendedTypes.WidgetInfo widgetInfo = AquaButtonExtendedTypes.getWidgetInfo(object);
            AquaUIPainter.State state = this.getState();
            if (state == AquaUIPainter.State.INACTIVE) {
                state = AquaUIPainter.State.ACTIVE;
            }
            if ((color2 = widgetInfo.getForeground(state, AquaUIPainter.ButtonState.STATELESS, this.colorDefaults)) != null) {
                return color2;
            }
        }
        return color;
    }

    protected AquaUIPainter.State getState() {
        if (!this.comboBox.isEnabled()) {
            return AquaFocusHandler.isActive(this.comboBox) ? AquaUIPainter.State.DISABLED : AquaUIPainter.State.DISABLED_INACTIVE;
        }
        ButtonModel buttonModel = this.getModel();
        if (buttonModel.isArmed() && buttonModel.isPressed()) {
            return AquaUIPainter.State.PRESSED;
        }
        if (this.isRollover) {
            return AquaUIPainter.State.ROLLOVER;
        }
        return AquaFocusHandler.isActive(this.comboBox) ? AquaUIPainter.State.ACTIVE : AquaUIPainter.State.INACTIVE;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Configuration configuration;
        boolean bl = AquaCellEditorPolicy.getInstance().isCellEditor(this.comboBox);
        boolean bl2 = this.comboBox.isEditable();
        if (bl2 && !bl) {
            return;
        }
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (n2 <= 0 || n <= 0) {
            return;
        }
        if (this.comboBox.isOpaque() || bl && !bl2 && !(this.comboBox.getParent() instanceof CellRendererPane)) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n, n2);
        }
        if ((configuration = this.getConfiguration()) != null) {
            this.painter.configure(n, n2);
            Painter painter = this.painter.getPainter(configuration);
            painter.paint(graphics, 0.0f, 0.0f);
            if (!bl2) {
                this.ui.paintValue(graphics);
            }
        }
    }

    public Configuration getConfiguration() {
        AquaUIPainter.State state = this.getState();
        AbstractComboBoxLayoutConfiguration abstractComboBoxLayoutConfiguration = this.getLayoutConfiguration();
        if (abstractComboBoxLayoutConfiguration instanceof PopupButtonLayoutConfiguration) {
            PopupButtonLayoutConfiguration popupButtonLayoutConfiguration = (PopupButtonLayoutConfiguration)abstractComboBoxLayoutConfiguration;
            return new PopupButtonConfiguration(popupButtonLayoutConfiguration, state);
        }
        if (abstractComboBoxLayoutConfiguration instanceof ComboBoxLayoutConfiguration) {
            ComboBoxLayoutConfiguration comboBoxLayoutConfiguration = (ComboBoxLayoutConfiguration)abstractComboBoxLayoutConfiguration;
            boolean bl = false;
            return new ComboBoxConfiguration(comboBoxLayoutConfiguration, state, bl);
        }
        return null;
    }

    private class RolloverMouseListener
    extends MouseAdapter {
        private RolloverMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            AquaComboBoxButton.this.isRollover = true;
            AquaComboBoxButton.this.comboBox.repaint();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            AquaComboBoxButton.this.isRollover = false;
            AquaComboBoxButton.this.comboBox.repaint();
        }
    }

    static class AquaComboBoxHierarchyListener
    implements HierarchyListener {
        AquaComboBoxHierarchyListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            Object object;
            if ((hierarchyEvent.getChangeFlags() & 1L) != 0L && (object = hierarchyEvent.getSource()) instanceof AquaComboBoxButton) {
                AquaComboBoxButton aquaComboBoxButton = (AquaComboBoxButton)object;
                aquaComboBoxButton.configure(null);
            }
        }
    }
}

