/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import org.violetlib.aqua.AquaButtonBorder;
import org.violetlib.aqua.AquaButtonToggleUI;
import org.violetlib.aqua.AquaNamedButtonBorder;
import org.violetlib.aqua.AquaSegmentedButtonBorder;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.jnr.aqua.AquaUIPainter;

public class AquaButtonExtendedTypes {
    protected static final AquaUtils.RecyclableSingleton<Map<String, TypeSpecifier>> typeDefinitions = new AquaUtils.RecyclableSingleton<Map<String, TypeSpecifier>>(){

        @Override
        protected Map<String, TypeSpecifier> getInstance() {
            return AquaButtonExtendedTypes.getAllTypes();
        }
    };
    protected static final WidgetInfo defaultButtonWidgetInfo = new WidgetInfo();
    protected static final WidgetInfo defaultSegmentedButtonWidgetInfo = new WidgetInfo(true);
    protected static final AquaUtils.RecyclableSingleton<Map<Object, WidgetInfo>> widgetDefinitions = new AquaUtils.RecyclableSingleton<Map<Object, WidgetInfo>>(){

        @Override
        protected Map<Object, WidgetInfo> getInstance() {
            return AquaButtonExtendedTypes.getAllWidgets();
        }
    };

    public static Border getBorder(AbstractButton abstractButton) {
        TypeSpecifier typeSpecifier = AquaButtonExtendedTypes.getTypeSpecifier(abstractButton);
        return typeSpecifier != null ? typeSpecifier.getBorder() : null;
    }

    public static TypeSpecifier getTypeSpecifier(AbstractButton abstractButton) {
        Object object = abstractButton.getClientProperty("JButton.buttonType");
        Object object2 = abstractButton.getClientProperty("JButton.segmentPosition");
        if (object == null) {
            if (object2 != null || abstractButton.getUI().getClass() == AquaButtonToggleUI.class) {
                object = "segmented";
            } else {
                return null;
            }
        }
        if (object instanceof String) {
            String string = (String)object;
            if (object2 instanceof String) {
                String string2 = (String)object2;
                String string3 = string + "-" + AquaButtonExtendedTypes.getRealPositionForLogicalPosition(string2, abstractButton.getComponentOrientation().isLeftToRight());
                TypeSpecifier typeSpecifier = AquaButtonExtendedTypes.getSpecifierByName(string3);
                if (typeSpecifier != null) {
                    return typeSpecifier;
                }
            }
            return AquaButtonExtendedTypes.getSpecifierByName(string);
        }
        return null;
    }

    protected static String getRealPositionForLogicalPosition(String string, boolean bl) {
        if (!bl) {
            if ("first".equalsIgnoreCase(string)) {
                return "last";
            }
            if ("last".equalsIgnoreCase(string)) {
                return "first";
            }
        }
        return string;
    }

    public static TypeSpecifier getSpecifierByName(String string) {
        return typeDefinitions.get().get(string);
    }

    public static Font getFont(Font font, Object object, AquaUIPainter.Size size) {
        WidgetInfo widgetInfo = AquaButtonExtendedTypes.getWidgetInfo(object);
        assert (widgetInfo != null);
        Font font2 = widgetInfo.getFont(size);
        if (font2 != null) {
            return font2;
        }
        if (size != null && size != AquaUIPainter.Size.REGULAR) {
            float f = AquaButtonExtendedTypes.getFontSize(size);
            return font.deriveFont(f);
        }
        return font;
    }

    protected static float getFontSize(AquaUIPainter.Size size) {
        switch (size) {
            case SMALL: {
                return 11.0f;
            }
            case MINI: {
                return 9.0f;
            }
        }
        return 13.0f;
    }

    public static WidgetInfo getWidgetInfo(Object object) {
        WidgetInfo widgetInfo = widgetDefinitions.get().get(object);
        if (widgetInfo != null) {
            return widgetInfo;
        }
        if (object instanceof AquaUIPainter.SegmentedButtonWidget) {
            return defaultSegmentedButtonWidgetInfo;
        }
        if (object instanceof AquaUIPainter.ButtonWidget) {
            return defaultButtonWidgetInfo;
        }
        return defaultButtonWidgetInfo;
    }

    protected static Map<Object, WidgetInfo> getAllWidgets() {
        HashMap<Object, WidgetInfo> hashMap = new HashMap<Object, WidgetInfo>();
        ColorUIResource colorUIResource = new ColorUIResource(Color.BLACK);
        ColorUIResource colorUIResource2 = new ColorUIResource(new Color(34, 34, 34));
        ColorUIResource colorUIResource3 = new ColorUIResource(new Color(0, 0, 0, 64));
        ColorUIResource colorUIResource4 = new ColorUIResource(new Color(0, 0, 0, 140));
        ColorUIResource colorUIResource5 = new ColorUIResource(new Color(0, 0, 0, 170));
        ColorUIResource colorUIResource6 = new ColorUIResource(new Color(0, 0, 0, 220));
        ColorUIResource colorUIResource7 = new ColorUIResource(new Color(255, 255, 255, 180));
        ColorUIResource colorUIResource8 = new ColorUIResource(Color.WHITE);
        hashMap.put((Object)AquaUIPainter.ButtonWidget.BUTTON_CHECK_BOX, new WidgetInfo());
        hashMap.put((Object)AquaUIPainter.ButtonWidget.BUTTON_RADIO, new WidgetInfo());
        hashMap.put((Object)AquaUIPainter.ButtonWidget.BUTTON_PUSH, new WidgetInfo().withForeground(colorUIResource2, colorUIResource3, colorUIResource8).withActiveDefaultButtonForeground(colorUIResource8));
        hashMap.put((Object)AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED, new WidgetInfo(true).withForeground(colorUIResource2, colorUIResource8, null, null).withDisabledForeground(new GrayUIResource(172), colorUIResource3).withInactiveForeground(colorUIResource2, null));
        WidgetInfo widgetInfo = new WidgetInfo().withForeground(colorUIResource6, colorUIResource6, colorUIResource3, null);
        hashMap.put((Object)AquaUIPainter.ButtonWidget.BUTTON_GRADIENT, widgetInfo);
        hashMap.put((Object)AquaUIPainter.ButtonWidget.BUTTON_BEVEL, widgetInfo);
        hashMap.put((Object)AquaUIPainter.ButtonWidget.BUTTON_BEVEL_ROUND, widgetInfo);
        hashMap.put((Object)AquaUIPainter.ButtonWidget.BUTTON_ROUNDED_RECT, widgetInfo);
        hashMap.put((Object)AquaUIPainter.ButtonWidget.BUTTON_ROUND, new WidgetInfo().withForeground(colorUIResource6, colorUIResource8, colorUIResource3, null));
        hashMap.put((Object)AquaUIPainter.ButtonWidget.BUTTON_TOOLBAR_ITEM, new WidgetInfo().withForeground(new GrayUIResource(89), new GrayUIResource(81), null, null).withDisabledForeground(new GrayUIResource(134), new GrayUIResource(150)).withInactiveForeground(new GrayUIResource(153), new GrayUIResource(172)).withInactiveDisabledForeground(new GrayUIResource(198), new GrayUIResource(173)).withFont(size -> size == AquaUIPainter.Size.SMALL || size == AquaUIPainter.Size.MINI ? UIManager.getFont("IconButton.smallFont") : UIManager.getFont("IconButton.font")).withIconTextGap(2));
        hashMap.put((Object)AquaUIPainter.ButtonWidget.BUTTON_INLINE, new WidgetInfo().withFont(UIManager.getFont("Button.inline.font")).withForeground(colorUIResource8, new GrayUIResource(240)));
        WidgetInfo widgetInfo2 = new WidgetInfo().withForeground(colorUIResource5, colorUIResource8, colorUIResource2).withDisabledForeground(colorUIResource7, colorUIResource4).withInactiveForeground(new GrayUIResource(161), new GrayUIResource(170)).withInactiveDisabledForeground(new GrayUIResource(247), new GrayUIResource(86));
        hashMap.put((Object)AquaUIPainter.ButtonWidget.BUTTON_TEXTURED, widgetInfo2);
        hashMap.put((Object)AquaUIPainter.ButtonWidget.BUTTON_ROUND_TEXTURED, widgetInfo2);
        hashMap.put((Object)AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED, widgetInfo2);
        hashMap.put((Object)AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED, widgetInfo2);
        hashMap.put((Object)AquaUIPainter.ButtonWidget.BUTTON_RECESSED, new WidgetInfo().withFont(UIManager.getFont("Button.recessed.font")).withRolloverEnabled(UIManager.getColor("Button.recessed.rolloverText")).withForeground(colorUIResource5, colorUIResource8).withDisabledForeground(colorUIResource7, colorUIResource4).withInactiveForeground(colorUIResource3).withInactiveDisabledForeground(colorUIResource7, colorUIResource4));
        hashMap.put((Object)AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_BEVEL, (WidgetInfo)hashMap.get((Object)AquaUIPainter.ButtonWidget.BUTTON_BEVEL));
        hashMap.put((Object)AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_BEVEL, (WidgetInfo)hashMap.get((Object)AquaUIPainter.ButtonWidget.BUTTON_BEVEL));
        hashMap.put((Object)AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_ROUND_RECT, (WidgetInfo)hashMap.get((Object)AquaUIPainter.ButtonWidget.BUTTON_ROUNDED_RECT));
        hashMap.put((Object)AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_ROUND_RECT, (WidgetInfo)hashMap.get((Object)AquaUIPainter.ButtonWidget.BUTTON_ROUNDED_RECT));
        hashMap.put((Object)AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_RECESSED, (WidgetInfo)hashMap.get((Object)AquaUIPainter.ButtonWidget.BUTTON_RECESSED));
        hashMap.put((Object)AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_RECESSED, (WidgetInfo)hashMap.get((Object)AquaUIPainter.ButtonWidget.BUTTON_RECESSED));
        hashMap.put((Object)AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_TEXTURED, (WidgetInfo)hashMap.get((Object)AquaUIPainter.ButtonWidget.BUTTON_TEXTURED));
        hashMap.put((Object)AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_TEXTURED, (WidgetInfo)hashMap.get((Object)AquaUIPainter.ButtonWidget.BUTTON_TEXTURED));
        hashMap.put((Object)AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_GRADIENT, (WidgetInfo)hashMap.get((Object)AquaUIPainter.ButtonWidget.BUTTON_GRADIENT));
        hashMap.put((Object)AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_GRADIENT, (WidgetInfo)hashMap.get((Object)AquaUIPainter.ButtonWidget.BUTTON_GRADIENT));
        return hashMap;
    }

    protected static Map<String, TypeSpecifier> getAllTypes() {
        TypeSpecifier[] typeSpecifierArray;
        HashMap<String, TypeSpecifier> hashMap = new HashMap<String, TypeSpecifier>();
        for (TypeSpecifier typeSpecifier : typeSpecifierArray = new TypeSpecifier[]{new FixedBorderTypeSpecifier("toolbar", AquaButtonBorder.getToolBarToggleButtonBorder()), new FixedBorderTypeSpecifier("icon", AquaButtonBorder.getIconToggleButtonBorder()), new FixedBorderTypeSpecifier("text", (AquaButtonBorder)UIManager.getBorder("Button.border")), new FixedBorderTypeSpecifier("toggle", AquaButtonBorder.getToggleButtonBorder()), new FixedBorderTypeSpecifier("disclosureTriangle", AquaButtonBorder.getDisclosureTriangleButtonBorder()), new FixedBorderTypeSpecifier("disclosure", AquaButtonBorder.getDisclosureButtonBorder()), new BorderDefinedTypeSpecifier("checkbox", AquaUIPainter.ButtonWidget.BUTTON_CHECK_BOX), new BorderDefinedTypeSpecifier("radio", AquaUIPainter.ButtonWidget.BUTTON_RADIO), new BorderDefinedTypeSpecifier("square", AquaUIPainter.ButtonWidget.BUTTON_BEVEL), new BorderDefinedTypeSpecifier("gradient", AquaUIPainter.ButtonWidget.BUTTON_GRADIENT), new BorderDefinedTypeSpecifier("bevel", AquaUIPainter.ButtonWidget.BUTTON_BEVEL_ROUND), new BorderDefinedTypeSpecifier("textured", AquaUIPainter.ButtonWidget.BUTTON_TEXTURED), new BorderDefinedTypeSpecifier("roundRect", AquaUIPainter.ButtonWidget.BUTTON_ROUNDED_RECT), new BorderDefinedTypeSpecifier("recessed", AquaUIPainter.ButtonWidget.BUTTON_RECESSED), new BorderDefinedTypeSpecifier("inline", AquaUIPainter.ButtonWidget.BUTTON_INLINE), new BorderDefinedTypeSpecifier("well", AquaUIPainter.ButtonWidget.BUTTON_TOOLBAR_ITEM), new BorderDefinedTypeSpecifier("toolbarItem", AquaUIPainter.ButtonWidget.BUTTON_TOOLBAR_ITEM), new BorderDefinedTypeSpecifier("help", AquaUIPainter.ButtonWidget.BUTTON_HELP), new BorderDefinedTypeSpecifier("round", AquaUIPainter.ButtonWidget.BUTTON_ROUND), new BorderDefinedTypeSpecifier("texturedRound", AquaUIPainter.ButtonWidget.BUTTON_ROUND_INSET), new BorderDefinedTypeSpecifier("roundTextured", AquaUIPainter.ButtonWidget.BUTTON_ROUND_TEXTURED), new BorderDefinedTypeSpecifier("roundInset", AquaUIPainter.ButtonWidget.BUTTON_ROUND_INSET), new BorderDefinedTypeSpecifier("colorWell", AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL), new SegmentedTypeSpecifier("segmented-first", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED, AquaUIPainter.Position.FIRST), new SegmentedTypeSpecifier("segmented-middle", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED, AquaUIPainter.Position.MIDDLE), new SegmentedTypeSpecifier("segmented-last", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED, AquaUIPainter.Position.LAST), new SegmentedTypeSpecifier("segmented-only", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED, AquaUIPainter.Position.ONLY), new SegmentedTypeSpecifier("segmentedRoundRect-first", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_INSET, AquaUIPainter.Position.FIRST), new SegmentedTypeSpecifier("segmentedRoundRect-middle", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_INSET, AquaUIPainter.Position.MIDDLE), new SegmentedTypeSpecifier("segmentedRoundRect-last", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_INSET, AquaUIPainter.Position.LAST), new SegmentedTypeSpecifier("segmentedRoundRect-only", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_INSET, AquaUIPainter.Position.ONLY), new SegmentedTypeSpecifier("segmentedTexturedRounded-first", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SCURVE, AquaUIPainter.Position.FIRST), new SegmentedTypeSpecifier("segmentedTexturedRounded-middle", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SCURVE, AquaUIPainter.Position.MIDDLE), new SegmentedTypeSpecifier("segmentedTexturedRounded-last", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SCURVE, AquaUIPainter.Position.LAST), new SegmentedTypeSpecifier("segmentedTexturedRounded-only", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SCURVE, AquaUIPainter.Position.ONLY), new SegmentedTypeSpecifier("segmentedTextured-first", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED, AquaUIPainter.Position.FIRST), new SegmentedTypeSpecifier("segmentedTextured-middle", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED, AquaUIPainter.Position.MIDDLE), new SegmentedTypeSpecifier("segmentedTextured-last", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED, AquaUIPainter.Position.LAST), new SegmentedTypeSpecifier("segmentedTextured-only", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED, AquaUIPainter.Position.ONLY), new SegmentedTypeSpecifier("segmentedCapsule-first", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TOOLBAR, AquaUIPainter.Position.FIRST), new SegmentedTypeSpecifier("segmentedCapsule-middle", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TOOLBAR, AquaUIPainter.Position.MIDDLE), new SegmentedTypeSpecifier("segmentedCapsule-last", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TOOLBAR, AquaUIPainter.Position.LAST), new SegmentedTypeSpecifier("segmentedCapsule-only", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TOOLBAR, AquaUIPainter.Position.ONLY), new SegmentedTypeSpecifier("segmentedGradient-first", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SMALL_SQUARE, AquaUIPainter.Position.FIRST), new SegmentedTypeSpecifier("segmentedGradient-middle", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SMALL_SQUARE, AquaUIPainter.Position.MIDDLE), new SegmentedTypeSpecifier("segmentedGradient-last", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SMALL_SQUARE, AquaUIPainter.Position.LAST), new SegmentedTypeSpecifier("segmentedGradient-only", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SMALL_SQUARE, AquaUIPainter.Position.ONLY), new SegmentedTypeSpecifier("segmentedTexturedSeparated-first", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED, AquaUIPainter.Position.FIRST), new SegmentedTypeSpecifier("segmentedTexturedSeparated-middle", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED, AquaUIPainter.Position.MIDDLE), new SegmentedTypeSpecifier("segmentedTexturedSeparated-last", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED, AquaUIPainter.Position.LAST), new SegmentedTypeSpecifier("segmentedTexturedSeparated-only", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED, AquaUIPainter.Position.ONLY)}) {
            hashMap.put(typeSpecifier.name, typeSpecifier);
        }
        return hashMap;
    }

    protected static class GrayUIResource
    extends ColorUIResource {
        public GrayUIResource(int n) {
            super(new Color(n, n, n));
        }
    }

    public static class WidgetInfo {
        private boolean isSegmented;
        private Color foreground;
        private Color selectedForeground;
        private Color inactiveForeground;
        private Color inactiveSelectedForeground;
        private Color disabledForeground;
        private Color disabledSelectedForeground;
        private Color inactiveDisabledForeground;
        private Color inactiveDisabledSelectedForeground;
        private Color rolloverForeground;
        private Color pressedForeground;
        private Color activeDefaultButtonForeground;
        private Font font;
        private FontFinder fontFinder;
        private float fontSize;
        private boolean isRolloverEnabled;
        private int iconTextGap;

        WidgetInfo() {
        }

        WidgetInfo(boolean bl) {
            this.isSegmented = bl;
        }

        WidgetInfo withFont(Font font) {
            this.font = font;
            return this;
        }

        WidgetInfo withFont(FontFinder fontFinder) {
            this.fontFinder = fontFinder;
            return this;
        }

        WidgetInfo withFontSize(float f) {
            this.fontSize = f;
            return this;
        }

        WidgetInfo withIconTextGap(int n) {
            this.iconTextGap = n;
            return this;
        }

        WidgetInfo withPressed(Color color) {
            this.pressedForeground = color;
            return this;
        }

        WidgetInfo withForeground(Color color) {
            this.foreground = color;
            return this;
        }

        WidgetInfo withForeground(Color color, Color color2) {
            this.foreground = color;
            this.disabledForeground = color2;
            return this;
        }

        WidgetInfo withForeground(Color color, Color color2, Color color3) {
            this.foreground = color;
            this.disabledForeground = color2;
            this.pressedForeground = color3;
            return this;
        }

        WidgetInfo withForeground(Color color, Color color2, Color color3, Color color4) {
            this.foreground = color;
            this.selectedForeground = color2;
            this.disabledForeground = color3;
            this.pressedForeground = color4;
            return this;
        }

        WidgetInfo withDisabledForeground(Color color, Color color2) {
            this.disabledSelectedForeground = color;
            this.disabledForeground = color2;
            return this;
        }

        WidgetInfo withInactiveForeground(Color color) {
            this.inactiveForeground = color;
            return this;
        }

        WidgetInfo withInactiveForeground(Color color, Color color2) {
            this.inactiveSelectedForeground = color;
            this.inactiveForeground = color2;
            return this;
        }

        WidgetInfo withInactiveDisabledForeground(Color color) {
            this.inactiveDisabledForeground = color;
            return this;
        }

        WidgetInfo withInactiveDisabledForeground(Color color, Color color2) {
            this.inactiveDisabledSelectedForeground = color;
            this.inactiveDisabledForeground = color2;
            return this;
        }

        WidgetInfo withActiveDefaultButtonForeground(Color color) {
            this.activeDefaultButtonForeground = color;
            return this;
        }

        WidgetInfo withRolloverEnabled(Color color) {
            this.isRolloverEnabled = true;
            this.rolloverForeground = color;
            return this;
        }

        public int getIconTextGap() {
            return this.iconTextGap;
        }

        public Font getFont(AquaUIPainter.Size size) {
            if (this.fontFinder != null) {
                return this.fontFinder.getFont(size);
            }
            if (this.font != null && size != null && size != AquaUIPainter.Size.REGULAR) {
                float f = AquaButtonExtendedTypes.getFontSize(size);
                return this.font.deriveFont(f);
            }
            return this.font;
        }

        public Color getForeground(AquaUIPainter.State state, AquaUIPainter.ButtonState buttonState, ColorDefaults colorDefaults) {
            if (this.isRolloverEnabled && state == AquaUIPainter.State.ROLLOVER && this.rolloverForeground != null) {
                return this.rolloverForeground;
            }
            if (state == AquaUIPainter.State.PRESSED && this.pressedForeground != null) {
                return this.pressedForeground;
            }
            if (state == AquaUIPainter.State.DISABLED_INACTIVE) {
                if (buttonState == AquaUIPainter.ButtonState.ON && this.inactiveDisabledSelectedForeground != null) {
                    return this.inactiveDisabledSelectedForeground;
                }
                if (this.inactiveDisabledForeground != null) {
                    return this.inactiveDisabledForeground;
                }
                state = AquaUIPainter.State.DISABLED;
            }
            if (state == AquaUIPainter.State.DISABLED) {
                if (buttonState == AquaUIPainter.ButtonState.ON && this.disabledSelectedForeground != null) {
                    return this.disabledSelectedForeground;
                }
                if (this.disabledForeground != null) {
                    return this.disabledForeground;
                }
                return colorDefaults.disabledTextColor;
            }
            if (state == AquaUIPainter.State.INACTIVE) {
                if (buttonState == AquaUIPainter.ButtonState.ON && this.inactiveSelectedForeground != null) {
                    return this.inactiveSelectedForeground;
                }
                if (this.inactiveForeground != null) {
                    return this.inactiveForeground;
                }
            }
            if (buttonState == AquaUIPainter.ButtonState.ON) {
                if (this.selectedForeground != null) {
                    return this.selectedForeground;
                }
                if (colorDefaults.selectedTextColor != null) {
                    return colorDefaults.selectedTextColor;
                }
            }
            if (state == AquaUIPainter.State.ACTIVE_DEFAULT && this.activeDefaultButtonForeground != null) {
                return this.activeDefaultButtonForeground;
            }
            if (this.foreground != null) {
                return this.foreground;
            }
            return colorDefaults.enabledTextColor;
        }

        public boolean isSegmented() {
            return this.isSegmented;
        }

        public boolean isRolloverEnabled() {
            return this.isRolloverEnabled;
        }
    }

    protected static interface FontFinder {
        public Font getFont(AquaUIPainter.Size var1);
    }

    public static class SegmentedTypeSpecifier
    extends TypeSpecifier {
        private final AquaUIPainter.SegmentedButtonWidget widget;
        private final WidgetInfo info;
        private final AquaUIPainter.Position position;

        public SegmentedTypeSpecifier(String string, AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget, AquaUIPainter.Position position) {
            super(string);
            this.widget = segmentedButtonWidget;
            this.info = AquaButtonExtendedTypes.getWidgetInfo((Object)segmentedButtonWidget);
            this.position = position;
        }

        @Override
        public AquaButtonBorder getBorder() {
            return new AquaSegmentedButtonBorder(this.widget, this.info, this.position);
        }
    }

    public static class BorderDefinedTypeSpecifier
    extends TypeSpecifier {
        private final AquaUIPainter.ButtonWidget widget;
        private final WidgetInfo info;

        public BorderDefinedTypeSpecifier(String string, AquaUIPainter.ButtonWidget buttonWidget) {
            super(string);
            this.widget = buttonWidget;
            this.info = AquaButtonExtendedTypes.getWidgetInfo((Object)buttonWidget);
        }

        @Override
        public AquaButtonBorder getBorder() {
            return new AquaNamedButtonBorder(this.widget, this.info);
        }
    }

    public static class FixedBorderTypeSpecifier
    extends TypeSpecifier {
        private final AquaButtonBorder border;

        public FixedBorderTypeSpecifier(String string, AquaButtonBorder aquaButtonBorder) {
            super(string);
            this.border = aquaButtonBorder;
        }

        @Override
        public AquaButtonBorder getBorder() {
            return this.border;
        }
    }

    public static abstract class TypeSpecifier {
        final String name;

        protected TypeSpecifier(String string) {
            this.name = string;
        }

        public abstract Border getBorder();
    }

    public static class ColorDefaults {
        public Color enabledTextColor;
        public Color selectedTextColor;
        public Color disabledTextColor;

        public Color getTextColor(boolean bl, boolean bl2) {
            if (bl) {
                return bl2 ? this.selectedTextColor : this.enabledTextColor;
            }
            return this.disabledTextColor;
        }
    }
}

